/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.connectivity;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardTaskBean;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.tasks.connectivity.AddEditPhoneInfo;
import com.ibm.hsc.iw.tasks.connectivity.AddPhonePrimer;
import com.ibm.hsc.iw.tasks.connectivity.ChangeModemConfig;
import com.ibm.hsc.iw.tasks.connectivity.ConnectivityConstants;
import com.ibm.hsc.iw.tasks.connectivity.ConnectivityInit;
import com.ibm.hsc.iw.tasks.connectivity.ConnectivityState;
import com.ibm.hwmca.fw.rcs.conndata.PhoneInfo;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class ConfigureDialUpBean
extends WizardTaskBean
implements ConnectivityConstants {
    private static final String TRACE_MASKD = "JIWZCDBD";
    private static final String TRACE_MASKF = "JIWZCDBF";
    private static final String TRACE_MASKT = "JIWZCDBT";
    private String m_sDialPrefix = "";
    private ItemDescriptor[][] m_idPhoneNumbersTable = new ItemDescriptor[0][0];
    private ColumnDescriptor[] m_cdPhoneNumbersTableStructure = new ColumnDescriptor[0];
    private int[] m_iPhoneNumbersTableSelection = new int[0];
    private ChangeModemConfig modemConfigData = null;
    private boolean modemConfigChanged = false;
    private List phoneNumbers;
    private ConnectivityState connectivityState;
    List addPredefinedNumbers = null;
    List addAvailCountries = null;
    String addCountryCode = null;
    Map addAvailSubdivisions = null;
    String addSubdivCode = null;

    public ConfigureDialUpBean(Object object) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->ConfigureDialUpBean()");
        }
        ConnectivityInit connectivityInit = (ConnectivityInit)object;
        this.connectivityState = connectivityInit.getConnectivityState();
        this.modemConfigData = this.connectivityState.getModemConfigData();
        this.setDialPrefix(this.modemConfigData.getDialPrefix());
        OutboundConfigData outboundConfigData = connectivityInit.getOutConfigData();
        this.setPhoneNumbers(outboundConfigData.getPhoneInfo());
        this.addPredefinedNumbers = connectivityInit.getPredefinedNumbers();
        this.addAvailCountries = connectivityInit.getAvailableCountries();
        this.addCountryCode = connectivityInit.getCountryCode();
        this.addAvailSubdivisions = connectivityInit.getAvailableSubdivisions();
        this.addSubdivCode = connectivityInit.getSubdivCode();
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--ConfigureDialUpBean()");
        }
    }

    public void setDialPrefix(String string) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->setDialPrefix(" + string + ")");
        }
        this.m_sDialPrefix = string;
        this.updateUTMElements();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--setDialPrefix()");
        }
    }

    public String getDialPrefix() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getDialPrefix() = " + this.m_sDialPrefix);
        }
        return this.m_sDialPrefix;
    }

    public void setPhoneNumbersTableSelection(int[] nArray) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            if (nArray != null && nArray.length > 0) {
                Trace.trace(TRACE_MASKT, "-->setPhoneNumbersTableSelection(" + nArray[0] + ")");
            } else {
                Trace.trace(TRACE_MASKT, "-->setPhoneNumbersTableSelection(none)");
            }
        }
        this.m_iPhoneNumbersTableSelection = nArray;
        this.updateUTMElements();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--setPhoneNumbersTableSelection()");
        }
        this.m_iPhoneNumbersTableSelection = nArray;
    }

    public int[] getPhoneNumbersTableSelection() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getPhoneNumbersTableSelection()");
        }
        return this.m_iPhoneNumbersTableSelection;
    }

    public void setPhoneNumbersTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->setPhoneNumbersTableRowAt()");
        }
        this.m_idPhoneNumbersTable[n] = itemDescriptorArray;
    }

    public ItemDescriptor[] getPhoneNumbersTableRowAt(int n) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getPhoneNumbersTableRowAt()");
        }
        return this.m_idPhoneNumbersTable[n];
    }

    public int getPhoneNumbersTableRowCount() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getPhoneNumbersTableRowCount()");
        }
        return this.m_idPhoneNumbersTable.length;
    }

    public int getPhoneNumbersTableRowStatus() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getPhoneNumbersTableRowStatus()");
        }
        return 3;
    }

    public ColumnDescriptor[] getPhoneNumbersTableRowStructure() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getPhoneNumbersTableRowStructure()");
        }
        return this.m_cdPhoneNumbersTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->load()");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--load()");
        }
    }

    public List getPhoneNumbers() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getPhoneNumbers()");
        }
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List list) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-->setPhoneNumbers(" + list.size() + ")");
        }
        this.phoneNumbers = list;
    }

    public void prepare() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->prepare()");
        }
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--prepare()");
        }
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + taskActionEvent.getCurrentElement() + "\n\tElementName   : " + taskActionEvent.getElementName() + "\n\tActionCommand : " + taskActionEvent.getActionCommand());
        }
        String string = taskActionEvent.getElementName();
        AddPhonePrimer addPhonePrimer = null;
        if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "AddButton1")) {
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Configure phone number ADD button hit");
            }
            addPhonePrimer = new AddPhonePrimer(this.getDialPrefix(), this.addAvailCountries, this.addCountryCode, this.addAvailSubdivisions, this.addSubdivCode, this.addPredefinedNumbers);
            this.display("com.ibm.hsc.iw.tasks.connectivity.res.Connectivity", "AddPhoneNumberPanel", "com.ibm.hsc.iw.tasks.connectivity.AddPhoneNumberBean", addPhonePrimer);
        } else if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "EditButton1")) {
            int[] nArray;
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Configure phone number EDIT button hit");
            }
            if ((nArray = this.getPhoneNumbersTableSelection()).length >= 1) {
                int n = nArray[0];
                this.display("com.ibm.hsc.iw.tasks.connectivity.res.Connectivity", "EditPhoneNumberPanel", "com.ibm.hsc.iw.tasks.connectivity.EditPhoneNumberBean", new AddEditPhoneInfo(this.getDialPrefix(), (PhoneInfo)this.phoneNumbers.get(n), null));
            }
        } else if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "RemoveButton1")) {
            int[] nArray;
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Configure phone number REMOVE button hit");
            }
            if ((nArray = this.getPhoneNumbersTableSelection()).length >= 1) {
                int n = nArray[0];
                this.phoneNumbers.remove(n);
                this.updateDataBeanInfo(false);
                if (this.phoneNumbers.size() >= 1) {
                    nArray[0] = n > 0 ? n - 1 : 0;
                } else {
                    nArray = new int[]{};
                }
                this.setPhoneNumbersTableSelection(nArray);
            }
        } else if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "UpButton1")) {
            int n;
            int[] nArray;
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Configure phone number UP button hit");
            }
            if ((nArray = this.getPhoneNumbersTableSelection()).length >= 1 && (n = nArray[0]) > 0) {
                PhoneInfo phoneInfo = (PhoneInfo)this.phoneNumbers.get(n - 1);
                this.phoneNumbers.set(n - 1, this.phoneNumbers.get(n));
                this.phoneNumbers.set(n, phoneInfo);
                this.updateDataBeanInfo(false);
                nArray[0] = n - 1;
                this.setPhoneNumbersTableSelection(nArray);
            }
        } else if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "DownButton1")) {
            int n;
            int[] nArray;
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Configure phone number DOWN button hit");
            }
            if ((nArray = this.getPhoneNumbersTableSelection()).length >= 1 && (n = nArray[0]) < this.phoneNumbers.size() - 1) {
                PhoneInfo phoneInfo = (PhoneInfo)this.phoneNumbers.get(n + 1);
                this.phoneNumbers.set(n + 1, this.phoneNumbers.get(n));
                this.phoneNumbers.set(n, phoneInfo);
                this.updateDataBeanInfo(false);
                nArray[0] = n + 1;
                this.setPhoneNumbersTableSelection(nArray);
            }
        } else if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "ModemConfigButton")) {
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Configure phone number MODEM CONFIG button hit");
            }
            this.display("com.ibm.hsc.iw.tasks.connectivity.res.Connectivity", "ModemConfigPanel", "com.ibm.hsc.iw.tasks.connectivity.ModemConfigBean", this.modemConfigData);
        } else {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
            }
            new AusMicrocodeLog(LOG_INFO_DIALUP, 1, new Exception(taskActionEvent.toString())).writeEntryFromTaskletClient();
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--panelAction()");
        }
    }

    public void displayComplete(Serializable serializable) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->displayComplete()");
        }
        if (serializable instanceof AddEditPhoneInfo) {
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "   displayComplete() - phone number changed");
            }
            AddEditPhoneInfo addEditPhoneInfo = (AddEditPhoneInfo)serializable;
            PhoneInfo phoneInfo = addEditPhoneInfo.getNewPhoneInfo();
            PhoneInfo phoneInfo2 = addEditPhoneInfo.getOldPhoneInfo();
            if (phoneInfo != null) {
                if (phoneInfo2 == null) {
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "newNumber=" + phoneInfo);
                    }
                    this.phoneNumbers.add(phoneInfo);
                    this.updateDataBeanInfo(false);
                    this.setPhoneNumbersTableSelection(new int[]{this.phoneNumbers.size() - 1});
                } else {
                    int[] nArray;
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "updatedNumber=" + phoneInfo);
                    }
                    if ((nArray = this.getPhoneNumbersTableSelection()).length >= 1) {
                        int n = nArray[0];
                        this.phoneNumbers.set(n, phoneInfo);
                    }
                    this.updateDataBeanInfo(false);
                    this.updateUTMElements();
                }
            }
        } else if (serializable instanceof ChangeModemConfig) {
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "   displayComplete() - modem config changed");
            }
            this.modemConfigChanged = true;
            this.modemConfigData = (ChangeModemConfig)serializable;
            this.setDialPrefix(this.modemConfigData.getDialPrefix());
        } else if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "displayComplete CANCEL path");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--displayComplete()");
        }
    }

    public Serializable nextButtonHit() throws WizardTaskException {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->nextButtonHit()");
        }
        if (this.phoneNumbers.size() < 1) {
            throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.ConnectivityText", "NO_DIALUP_ENTRY_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0605", null));
        }
        if (this.modemConfigChanged) {
            this.connectivityState.modemConfigHasChanged();
        }
        this.connectivityState.saveDialUpState(this.modemConfigData, this.phoneNumbers);
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--nextButtonHit()");
        }
        return this.connectivityState;
    }

    public Serializable backButtonHit() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->backButtonHit()");
        }
        if (this.modemConfigChanged) {
            this.connectivityState.modemConfigHasChanged();
        }
        this.connectivityState.saveDialUpState(this.modemConfigData, this.phoneNumbers);
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--backButtonHit()");
        }
        return this.connectivityState;
    }

    private void updateDataBeanInfo(boolean bl) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->updateDataBeanInfo(" + bl + ")");
        }
        this.m_idPhoneNumbersTable = new ItemDescriptor[this.phoneNumbers.size()][2];
        for (int i = 0; i < this.phoneNumbers.size(); ++i) {
            PhoneInfo phoneInfo = (PhoneInfo)this.phoneNumbers.get(i);
            String string = phoneInfo.getPhoneNumber();
            this.m_idPhoneNumbersTable[i][0] = new ItemDescriptor(null, string);
            String string2 = phoneInfo.getDescription();
            this.m_idPhoneNumbersTable[i][1] = new ItemDescriptor(null, string2);
        }
        if (bl) {
            if (this.m_sDialPrefix == null) {
                this.m_sDialPrefix = "";
            }
            this.m_cdPhoneNumbersTableStructure = new ColumnDescriptor[0];
            this.m_iPhoneNumbersTableSelection = this.phoneNumbers.size() >= 1 ? new int[]{0} : new int[0];
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--updateDataBeanInfo()");
        }
    }

    private void updateUTMElements() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->updateUTMElements()");
        }
        if (this.userTaskManager != null) {
            String string = this.getMountPrefix();
            this.userTaskManager.setEnabled(string + "ModemConfigButton", true);
            this.userTaskManager.setEnabled(string + "PhoneNumbersGroup", true);
            this.userTaskManager.setEnabled(string + "PhoneNumbersTable", true);
            if (this.phoneNumbers.size() < 5) {
                this.userTaskManager.setEnabled(string + "AddButton1", true);
            } else {
                this.userTaskManager.setEnabled(string + "AddButton1", false);
            }
            if (this.phoneNumbers.size() > 0) {
                this.userTaskManager.setEnabled(string + "EditButton1", true);
                this.userTaskManager.setEnabled(string + "RemoveButton1", true);
            } else {
                this.userTaskManager.setEnabled(string + "EditButton1", false);
                this.userTaskManager.setEnabled(string + "RemoveButton1", false);
            }
            if (this.phoneNumbers.size() > 1) {
                this.userTaskManager.setEnabled(string + "UpButton1", true);
                this.userTaskManager.setEnabled(string + "DownButton1", true);
            } else {
                this.userTaskManager.setEnabled(string + "UpButton1", false);
                this.userTaskManager.setEnabled(string + "DownButton1", false);
            }
            this.userTaskManager.refreshElement(string + "ModemGroup");
            this.userTaskManager.refreshElement(string + "DialPrefix");
            this.userTaskManager.refreshElement(string + "ModemConfigButton");
            this.userTaskManager.refreshElement(string + "PhoneNumbersGroup");
            this.userTaskManager.refreshElement(string + "PhoneNumbersTable");
            this.userTaskManager.refreshElement(string + "AddButton1");
            this.userTaskManager.refreshElement(string + "EditButton1");
            this.userTaskManager.refreshElement(string + "RemoveButton1");
            this.userTaskManager.refreshElement(string + "UpButton1");
            this.userTaskManager.refreshElement(string + "DownButton1");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--updateUTMElements()");
        }
    }
}

